import bge
import options
import os
import random
import aud

endTimer = None
def end(cont):
    global endTimer
    end_tower = cont.owner    
    if endTimer == None:
        endTimer = 0
    endTimer += 1
    if endTimer < 15:
        player = [o for o in bge.logic.getCurrentScene().objects if 'ball_manager' in o][0]
        player_pos = list(end_tower.worldPosition[:])
        player_pos[2] += 0.5
        player.worldPosition = player_pos
        col = player.color
        col[3] -= .01
        player.color = col
    elif endTimer == 15:
        for o in bge.logic.getCurrentScene().objects:
            o.endObject()
        options.increase_start_level()
        bge.logic.startGame(bge.logic.expandPath('//Neon Ball.blend'))

    
def init(cont):
    '''Starts the level with the user-defined settings'''
    #Set to player Camera
    print('Setting to player camera')
    cont.activate(cont.actuators['Scene'])

    BLUR = options.get_blur()
    BLOOM = options.get_bloom()
    MUSIC = options.get_music()

    print('Blur to status: {}'.format(BLUR))
    if BLUR == True:
        cont.activate(cont.actuators['BLUR'])
    print('Bloom to status: {}'.format(BLOOM))
    if BLOOM == True:
        cont.activate(cont.actuators['BLOOM'])

    bge.render.showMouse(0)

    if MUSIC == True:
        start_music()

def start_music():

    #Select Music
    path = bge.logic.expandPath('//sounds/music')
    music_list = [f for f in os.listdir(path) if os.path.isfile(os.path.join(path,f))]
    if music_list == []:
        return
    selected_music = random.choice(music_list)
    
    #Start Music
    device = aud.device()
    factory = aud.Factory(os.path.join(path,selected_music))
    factory.loop(-1)
    handle = device.play(factory)

def restart(cont):
    ball_manager = [o for o in bge.logic.getCurrentScene().objects if 'ball_manager' in o][0]
    camera_manager = [o for o in bge.logic.getCurrentScene().objects if 'camera_manager' in o][0]
    ball_graphics = [o for o in bge.logic.getCurrentScene().objects if 'ball_graphics' in o][0]

    ball_graphics.worldPosition = [0,0,0.2]
    ball_graphics.worldLinearVelocity = [0,0,0]
    ball_manager.worldPosition = [0,0,0.2]
    ball_manager.worldLinearVelocity = [0,0,0]
    camera_manager.worldPosition = [0,0,0.2]
    camera_manager.worldLinearVelocity = [0,0,0]



def add_lamp(cont):
    '''Adds a lamp at the location of the object calling this script. This is due to a stupid limitation of libLoad'''
    lamp_object = bge.logic.getCurrentScene().objectsInactive['level_light']
    bge.logic.getCurrentScene().addObject(lamp_object, cont.owner)

def add_end_light(cont):
    '''Adds a lamp at the location of the object calling this script. This is due to a stupid limitation of libLoad'''
    lamp_object = bge.logic.getCurrentScene().objectsInactive['end_light']
    bge.logic.getCurrentScene().addObject(lamp_object, cont.owner)

def add_hover_light(cont):
    '''Adds a lamp at the location of the object calling this script. This is due to a stupid limitation of libLoad'''
    lamp_object = bge.logic.getCurrentScene().objectsInactive['hover_light']
    bge.logic.getCurrentScene().addObject(lamp_object, cont.owner)
